package gov.va.genisis2Test.daoImp;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

import gov.va.genisis2.dao.impl.CommentHistoryDao;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * The Class CommentHistoryDaoTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class CommentHistoryDaoTest.
 * 
 *          Description: In this CommentHistoryDaoTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class CommentHistoryDaoTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(CommentHistoryDaoTest.class);

	/**
	 * To test hibernate template.
	 */
	@Test
	public void TestGetTemplate() {
		// testing for Hibernate Template
		logger.info("**********Junit Test Get Template**********");

		CommentHistoryDao commentHistoryDao = new CommentHistoryDao();
		HibernateTemplate hibernateTemplate = commentHistoryDao.getHibernateTemplate();
		// for coverage
		Assert.assertNull(hibernateTemplate);
		commentHistoryDao.setHibernateTemplate(getMockHibernateTemplate());
		hibernateTemplate = commentHistoryDao.getHibernateTemplate();
		Assert.assertNotNull(hibernateTemplate);

	}

	/**
	 * Test comment history null.
	 */
	@Test
	public void TestCommentHistory_null() {
		// testing when comment history is null
		logger.info("**********Junit Test Create Comment History Null**********");

		CommentHistory commentHistory = new CommentHistory();
		getMockHibernateTemplate().save(commentHistory);
		int id = getMockCommentHistoryDao().createCommentHistory(commentHistory);

	}

	/**
	 * Test create request not null.
	 */
	@Test
	public void TestCreateRequest_notNull() {
		// testing when comment history are not null
		logger.info("**********Junit Test Create Comment History Not Null**********");

		CommentHistory commentHistory = new CommentHistory(2, null, null, "commentsTestOne", new Date(),
				"createdByTestOne", "taskIdTestOne");

		getMockHibernateTemplate().save(commentHistory);

		int id = getMockCommentHistoryDao().createCommentHistory(commentHistory);

	}

	/**
	 * Test get comment histories.
	 */
	@Test
	public void TestGetCommentHistories() {

		logger.info("**********Junit Test Get Comment Histories**********");

		CommentHistoryDao commentHistoryDao = new CommentHistoryDao();
		commentHistoryDao.setHibernateTemplate(getMockHibernateTemplate());
		List<CommentHistory> CommentHistories = commentHistoryDao.getCommentHistories();

	}

	/**
	 * Test get comment histories by ID.
	 */
	@Test
	public void TestGetCommentHistoriesByID() {

		logger.info("**********Junit Test Get Comment Histories By ID**********");
		
		CommentHistoryDao commentHistoryDao = new CommentHistoryDao();
		commentHistoryDao.setHibernateTemplate(getMockHibernateTemplate());
		CommentHistory commentHistory = commentHistoryDao.getCommentHistoriesByID(1);
	}

	/**
	 * Test get comment histories by UID.
	 */
	@Test
	public void TestGetCommentHistoriesByUID() {

		logger.info("**********Junit Test Get Comment Histories By UID**********");

		List<CommentHistory> CommentHistories = getMockCommentHistoryDao().getCommentHistoriesByUID("testresearcher");
	}

	/**
	 * Test ge ccomment history by comment id.
	 */
	@Test
	public void TestGetCommentHistoryByCommentId() {

		logger.info("**********Junit Test Get Requests By Comment Id**********");

		CommentHistory commentHistory = new CommentHistory(2, null, null, "commentsTestOne", new Date(), "createdByTestOne",
				"taskIdTestOne");
		
		getMockHibernateTemplate().save(commentHistory);
		
		CommentHistory commentHistory1 = getMockCommentHistoryDao().getCommentHistoryByCommentId(2);
	}

	/**
	 * Test get comment history by id.
	 */
	@Test
	public void TestGetCommentHistoryById() {

		logger.info("**********Junit Test Get Comment History By Id**********");

		List<CommentHistory> CommentHistories = getMockCommentHistoryDao().getCommentHistoryById(1);

	}

	/**
	 * Test get comment history by status.
	 */
	@Test
	public void TestGetCommentHistoryByStarus() {

		logger.info("**********Junit Test Get Comment History By Status**********");

		List<CommentHistory> CommentHistories = getMockCommentHistoryDao().getCommentHistoryByRequestIdStatusId(1,
				"Submitted");

	}

	/**
	 * Test submit or modify.
	 */
	@Test
	public void TestSubmitOrModify() {

		logger.info("**********Junit Test Submit Or Modify**********");
		
		CommentHistory commentHistory = new CommentHistory();
		getMockHibernateTemplate().save(commentHistory);
		commentHistory.setComments("modified description");
		int id1 = getMockCommentHistoryDao().submitOrModify(commentHistory);
	}

	/**
	 * Test update comment history.
	 */
	@Test
	public void TestUpdateCommentHistory() {

		logger.info("**********Junit Test Update Comment History**********");

		CommentHistory commentHistory = new CommentHistory();
		getMockHibernateTemplate().save(commentHistory);
		commentHistory.setComments("modified description");
		int id1 = getMockCommentHistoryDao().updateCommentHistory(commentHistory);
	}

}
